package gov.va.med.mhv.sm.api.enumeration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public enum EmailNotificationEnum {

	//NONE(0L,"None"),
	EACH_MESSAGE(1L, "Each message"),
	ONE_DAILY(2L, "Once daily");
	//ON_ASSIGNEMNT(3L, "On assignment to me");
	
	private Long id;
	private String name;
	
	public static final Map<Long, EmailNotificationEnum> EMAIL_NOTIFICATION_CODE = new TreeMap<Long, EmailNotificationEnum>();
	public static final Map<Long, String> EMAIL_NOTIFICATION_DETAIL = new TreeMap<Long, String>();
	
	/* static initializer */
	static {
		for (EmailNotificationEnum notificationEn : values()) {
			EMAIL_NOTIFICATION_CODE.put(notificationEn.getId(), notificationEn);
			EMAIL_NOTIFICATION_DETAIL.put(notificationEn.getId(), notificationEn.getName());
		}
	}
	
	private EmailNotificationEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}

	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static EmailNotificationEnum valueOf(Long value){
		for(EmailNotificationEnum f : EmailNotificationEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; return default */
		return EmailNotificationEnum.ONE_DAILY;
	}
	
	public static List<EmailNotificationEnum> toList(){
		return Arrays.asList(EmailNotificationEnum.values());
	}
	
}
